/*
 * Decompiled with CFR 0.152.
 */
package baritone.api.utils;

import baritone.api.utils.SettingsUtil;
import javax.annotation.Nonnull;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_3532;

public final class BetterBlockPos
extends class_2338 {
    private static final int NUM_X_BITS = 26;
    private static final int NUM_Z_BITS = 26;
    private static final int NUM_Y_BITS = 12;
    private static final int Y_SHIFT = 26;
    private static final int X_SHIFT = 38;
    private static final long X_MASK = 0x3FFFFFFL;
    private static final long Y_MASK = 4095L;
    private static final long Z_MASK = 0x3FFFFFFL;
    public static final BetterBlockPos ORIGIN = new BetterBlockPos(0, 0, 0);
    public final int x;
    public final int y;
    public final int z;

    public BetterBlockPos(int n, int n2, int n3) {
        super(n, n2, n3);
        this.x = n;
        this.y = n2;
        this.z = n3;
    }

    public BetterBlockPos(double d, double d2, double d3) {
        this(class_3532.method_15357((double)d), class_3532.method_15357((double)d2), class_3532.method_15357((double)d3));
    }

    public BetterBlockPos(class_2338 class_23382) {
        this(class_23382.method_10263(), class_23382.method_10264(), class_23382.method_10260());
    }

    public static BetterBlockPos from(class_2338 class_23382) {
        if (class_23382 == null) {
            return null;
        }
        return new BetterBlockPos(class_23382);
    }

    public final int hashCode() {
        return (int)BetterBlockPos.longHash(this.x, this.y, this.z);
    }

    public static long longHash(BetterBlockPos betterBlockPos) {
        return BetterBlockPos.longHash(betterBlockPos.x, betterBlockPos.y, betterBlockPos.z);
    }

    public static long longHash(int n, int n2, int n3) {
        long l = 11206370049L + (long)n;
        l = 8734625L * l + (long)n2;
        return 2873465L * l + (long)n3;
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof BetterBlockPos) {
            object = (BetterBlockPos)((Object)object);
            return ((BetterBlockPos)((Object)object)).x == this.x && ((BetterBlockPos)((Object)object)).y == this.y && ((BetterBlockPos)((Object)object)).z == this.z;
        }
        return (object = (class_2338)object).method_10263() == this.x && object.method_10264() == this.y && object.method_10260() == this.z;
    }

    public final BetterBlockPos above() {
        return new BetterBlockPos(this.x, this.y + 1, this.z);
    }

    public final BetterBlockPos above(int n) {
        if (n == 0) {
            return this;
        }
        return new BetterBlockPos(this.x, this.y + n, this.z);
    }

    public final BetterBlockPos below() {
        return new BetterBlockPos(this.x, this.y - 1, this.z);
    }

    public final BetterBlockPos below(int n) {
        if (n == 0) {
            return this;
        }
        return new BetterBlockPos(this.x, this.y - n, this.z);
    }

    public final BetterBlockPos relative(class_2350 class_23502) {
        class_23502 = class_23502.method_62675();
        return new BetterBlockPos(this.x + class_23502.method_10263(), this.y + class_23502.method_10264(), this.z + class_23502.method_10260());
    }

    public final BetterBlockPos relative(class_2350 class_23502, int n) {
        if (n == 0) {
            return this;
        }
        class_23502 = class_23502.method_62675();
        return new BetterBlockPos(this.x + class_23502.method_10263() * n, this.y + class_23502.method_10264() * n, this.z + class_23502.method_10260() * n);
    }

    public final BetterBlockPos north() {
        return new BetterBlockPos(this.x, this.y, this.z - 1);
    }

    public final BetterBlockPos north(int n) {
        if (n == 0) {
            return this;
        }
        return new BetterBlockPos(this.x, this.y, this.z - n);
    }

    public final BetterBlockPos south() {
        return new BetterBlockPos(this.x, this.y, this.z + 1);
    }

    public final BetterBlockPos south(int n) {
        if (n == 0) {
            return this;
        }
        return new BetterBlockPos(this.x, this.y, this.z + n);
    }

    public final BetterBlockPos east() {
        return new BetterBlockPos(this.x + 1, this.y, this.z);
    }

    public final BetterBlockPos east(int n) {
        if (n == 0) {
            return this;
        }
        return new BetterBlockPos(this.x + n, this.y, this.z);
    }

    public final BetterBlockPos west() {
        return new BetterBlockPos(this.x - 1, this.y, this.z);
    }

    public final BetterBlockPos west(int n) {
        if (n == 0) {
            return this;
        }
        return new BetterBlockPos(this.x - n, this.y, this.z);
    }

    public final double distanceSq(BetterBlockPos betterBlockPos) {
        double d = (double)this.x - (double)betterBlockPos.x;
        double d2 = (double)this.y - (double)betterBlockPos.y;
        double d3 = (double)this.z - (double)betterBlockPos.z;
        double d4 = d;
        double d5 = d2;
        double d6 = d3;
        return d4 * d4 + d5 * d5 + d6 * d6;
    }

    public final double distanceTo(BetterBlockPos betterBlockPos) {
        double d = (double)this.x - (double)betterBlockPos.x;
        double d2 = (double)this.y - (double)betterBlockPos.y;
        double d3 = (double)this.z - (double)betterBlockPos.z;
        double d4 = d;
        double d5 = d2;
        double d6 = d3;
        return Math.sqrt(d4 * d4 + d5 * d5 + d6 * d6);
    }

    @Nonnull
    public final String toString() {
        return String.format("BetterBlockPos{x=%s,y=%s,z=%s}", SettingsUtil.maybeCensor(this.x), SettingsUtil.maybeCensor(this.y), SettingsUtil.maybeCensor(this.z));
    }

    public static long serializeToLong(int n, int n2, int n3) {
        return ((long)n & 0x3FFFFFFL) << 38 | ((long)n2 & 0xFFFL) << 26 | (long)n3 & 0x3FFFFFFL;
    }

    public static BetterBlockPos deserializeFromLong(long l) {
        int n = (int)(l >> 38);
        int n2 = (int)(l << 26 >> 52);
        int n3 = (int)(l << 38 >> 38);
        return new BetterBlockPos(n, n2, n3);
    }

    public final /* synthetic */ class_2338 method_10079(class_2350 class_23502, int n) {
        return this.relative(class_23502, n);
    }

    public final /* synthetic */ class_2338 method_10093(class_2350 class_23502) {
        return this.relative(class_23502);
    }

    public final /* synthetic */ class_2338 method_10089(int n) {
        return this.east(n);
    }

    public final /* synthetic */ class_2338 method_10078() {
        return this.east();
    }

    public final /* synthetic */ class_2338 method_10088(int n) {
        return this.west(n);
    }

    public final /* synthetic */ class_2338 method_10067() {
        return this.west();
    }

    public final /* synthetic */ class_2338 method_10077(int n) {
        return this.south(n);
    }

    public final /* synthetic */ class_2338 method_10072() {
        return this.south();
    }

    public final /* synthetic */ class_2338 method_10076(int n) {
        return this.north(n);
    }

    public final /* synthetic */ class_2338 method_10095() {
        return this.north();
    }

    public final /* synthetic */ class_2338 method_10087(int n) {
        return this.below(n);
    }

    public final /* synthetic */ class_2338 method_10074() {
        return this.below();
    }

    public final /* synthetic */ class_2338 method_10086(int n) {
        return this.above(n);
    }

    public final /* synthetic */ class_2338 method_10084() {
        return this.above();
    }

    public final /* synthetic */ class_2382 method_10259(class_2382 class_23822) {
        return super.method_10075(class_23822);
    }

    public final /* synthetic */ class_2382 method_35850(class_2350.class_2351 class_23512, int n) {
        return super.method_30513(class_23512, n);
    }

    public final /* synthetic */ class_2382 method_23226(class_2350 class_23502, int n) {
        return this.relative(class_23502, n);
    }

    public final /* synthetic */ class_2382 method_35851(class_2350 class_23502) {
        return this.relative(class_23502);
    }

    public final /* synthetic */ class_2382 method_35854(int n) {
        return this.east(n);
    }

    public final /* synthetic */ class_2382 method_35855() {
        return this.east();
    }

    public final /* synthetic */ class_2382 method_35856(int n) {
        return this.west(n);
    }

    public final /* synthetic */ class_2382 method_35857() {
        return this.west();
    }

    public final /* synthetic */ class_2382 method_35858(int n) {
        return this.south(n);
    }

    public final /* synthetic */ class_2382 method_35859() {
        return this.south();
    }

    public final /* synthetic */ class_2382 method_35860(int n) {
        return this.north(n);
    }

    public final /* synthetic */ class_2382 method_35861() {
        return this.north();
    }

    public final /* synthetic */ class_2382 method_23227(int n) {
        return this.below(n);
    }

    public final /* synthetic */ class_2382 method_23228() {
        return this.below();
    }

    public final /* synthetic */ class_2382 method_30930(int n) {
        return this.above(n);
    }

    public final /* synthetic */ class_2382 method_30931() {
        return this.above();
    }

    public final /* synthetic */ class_2382 method_35862(int n) {
        return super.method_35830(n);
    }

    public final /* synthetic */ class_2382 method_35852(class_2382 class_23822) {
        return super.method_10059(class_23822);
    }

    public final /* synthetic */ class_2382 method_35853(class_2382 class_23822) {
        return super.method_10081(class_23822);
    }

    public final /* synthetic */ class_2382 method_34592(int n, int n2, int n3) {
        return super.method_10069(n, n2, n3);
    }

    public final /* synthetic */ int compareTo(Object object) {
        return super.method_10265((class_2382)object);
    }
}

