/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.gui.screens.settings;

import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.gui.GuiTheme;
import meteordevelopment.meteorclient.gui.WidgetScreen;
import meteordevelopment.meteorclient.gui.WindowScreen;
import meteordevelopment.meteorclient.gui.renderer.GuiRenderer;
import meteordevelopment.meteorclient.gui.widgets.WQuad;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.gui.widgets.containers.WHorizontalList;
import meteordevelopment.meteorclient.gui.widgets.containers.WTable;
import meteordevelopment.meteorclient.gui.widgets.input.WIntEdit;
import meteordevelopment.meteorclient.gui.widgets.pressable.WButton;
import meteordevelopment.meteorclient.gui.widgets.pressable.WCheckbox;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.utils.misc.NbtUtils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import net.minecraft.class_3532;
import net.minecraft.class_437;

public class ColorSettingScreen
extends WindowScreen {
    private static final Color[] HUE_COLORS = new Color[]{new Color(255, 0, 0), new Color(255, 255, 0), new Color(0, 255, 0), new Color(0, 255, 255), new Color(0, 0, 255), new Color(255, 0, 255), new Color(255, 0, 0)};
    private static final Color WHITE = new Color(255, 255, 255);
    private static final Color BLACK = new Color(0, 0, 0);
    public Runnable action;
    private final Setting<SettingColor> setting;
    private WQuad displayQuad;
    private WBrightnessQuad brightnessQuad;
    private WHueQuad hueQuad;
    private WIntEdit rItb;
    private WIntEdit gItb;
    private WIntEdit bItb;
    private WIntEdit aItb;
    private WCheckbox rainbow;

    public ColorSettingScreen(GuiTheme theme, Setting<SettingColor> setting) {
        super(theme, "Select Color");
        this.setting = setting;
    }

    @Override
    public void initWidgets() {
        this.displayQuad = this.add(this.theme.quad(this.setting.get())).expandX().widget();
        this.brightnessQuad = this.add(new WBrightnessQuad()).expandX().widget();
        this.hueQuad = this.add(new WHueQuad()).expandX().widget();
        WTable rgbaTable = this.add(this.theme.table()).expandX().widget();
        rgbaTable.add(this.theme.label("R:"));
        this.rItb = rgbaTable.add(this.theme.intEdit(this.setting.get().r, 0, 255, 0, 255, false)).expandX().widget();
        this.rItb.action = this::rgbaChanged;
        rgbaTable.row();
        rgbaTable.add(this.theme.label("G:"));
        this.gItb = rgbaTable.add(this.theme.intEdit(this.setting.get().g, 0, 255, 0, 255, false)).expandX().widget();
        this.gItb.action = this::rgbaChanged;
        rgbaTable.row();
        rgbaTable.add(this.theme.label("B:"));
        this.bItb = rgbaTable.add(this.theme.intEdit(this.setting.get().b, 0, 255, 0, 255, false)).expandX().widget();
        this.bItb.action = this::rgbaChanged;
        rgbaTable.row();
        rgbaTable.add(this.theme.label("A:"));
        this.aItb = rgbaTable.add(this.theme.intEdit(this.setting.get().a, 0, 255, 0, 255, false)).expandX().widget();
        this.aItb.action = this::rgbaChanged;
        WHorizontalList rainbowList = this.add(this.theme.horizontalList()).expandX().widget();
        rainbowList.add(this.theme.label("Rainbow: "));
        this.rainbow = this.theme.checkbox(this.setting.get().rainbow);
        this.rainbow.action = () -> {
            this.setting.get().rainbow = this.rainbow.checked;
            this.setting.onChanged();
        };
        rainbowList.add(this.rainbow).expandCellX().right();
        WHorizontalList bottomList = this.add(this.theme.horizontalList()).expandX().widget();
        WButton backButton = bottomList.add(this.theme.button("Back")).expandX().widget();
        backButton.action = this::method_25419;
        WButton copyButton = bottomList.add(this.theme.button(GuiRenderer.COPY)).widget();
        copyButton.action = this::toClipboard;
        copyButton.tooltip = "Copy config";
        WButton pasteButton = bottomList.add(this.theme.button(GuiRenderer.PASTE)).widget();
        pasteButton.action = this::fromClipboard;
        pasteButton.tooltip = "Paste config";
        WButton resetButton = bottomList.add(this.theme.button(GuiRenderer.RESET)).widget();
        resetButton.action = () -> {
            this.setting.reset();
            this.setFromSetting();
            this.callAction();
        };
        resetButton.tooltip = "Reset";
        this.hueQuad.calculateFromSetting(false);
        this.brightnessQuad.calculateFromColor(this.setting.get(), false);
    }

    private void setFromSetting() {
        SettingColor c = this.setting.get();
        if (c.r != this.rItb.get()) {
            this.rItb.set(c.r);
        }
        if (c.g != this.gItb.get()) {
            this.gItb.set(c.g);
        }
        if (c.b != this.bItb.get()) {
            this.bItb.set(c.b);
        }
        if (c.a != this.aItb.get()) {
            this.aItb.set(c.a);
        }
        this.rainbow.checked = c.rainbow;
        this.displayQuad.color.set(this.setting.get());
        this.hueQuad.calculateFromSetting(true);
        this.brightnessQuad.calculateFromColor(this.setting.get(), true);
    }

    private void callAction() {
        if (this.action != null) {
            this.action.run();
        }
    }

    public void method_25393() {
        super.method_25393();
        if (this.setting.get().rainbow) {
            this.setFromSetting();
        }
    }

    private void rgbaChanged() {
        Color c = this.setting.get();
        c.r = this.rItb.get();
        c.g = this.gItb.get();
        c.b = this.bItb.get();
        c.a = this.aItb.get();
        c.validate();
        if (c.r != this.rItb.get()) {
            this.rItb.set(c.r);
        }
        if (c.g != this.gItb.get()) {
            this.gItb.set(c.g);
        }
        if (c.b != this.bItb.get()) {
            this.bItb.set(c.b);
        }
        if (c.a != this.aItb.get()) {
            this.aItb.set(c.a);
        }
        this.displayQuad.color.set(c);
        this.hueQuad.calculateFromSetting(true);
        this.brightnessQuad.calculateFromColor(this.setting.get(), true);
        this.setting.onChanged();
        this.callAction();
    }

    private void hsvChanged() {
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        boolean calculated = false;
        if (this.brightnessQuad.saturation <= 0.0) {
            r = this.brightnessQuad.value;
            g = this.brightnessQuad.value;
            b = this.brightnessQuad.value;
            calculated = true;
        }
        if (!calculated) {
            double hh = this.hueQuad.hueAngle;
            if (hh >= 360.0) {
                hh = 0.0;
            }
            int i = (int)(hh /= 60.0);
            double ff = hh - (double)i;
            double p = this.brightnessQuad.value * (1.0 - this.brightnessQuad.saturation);
            double q = this.brightnessQuad.value * (1.0 - this.brightnessQuad.saturation * ff);
            double t = this.brightnessQuad.value * (1.0 - this.brightnessQuad.saturation * (1.0 - ff));
            switch (i) {
                case 0: {
                    r = this.brightnessQuad.value;
                    g = t;
                    b = p;
                    break;
                }
                case 1: {
                    r = q;
                    g = this.brightnessQuad.value;
                    b = p;
                    break;
                }
                case 2: {
                    r = p;
                    g = this.brightnessQuad.value;
                    b = t;
                    break;
                }
                case 3: {
                    r = p;
                    g = q;
                    b = this.brightnessQuad.value;
                    break;
                }
                case 4: {
                    r = t;
                    g = p;
                    b = this.brightnessQuad.value;
                    break;
                }
                default: {
                    r = this.brightnessQuad.value;
                    g = p;
                    b = q;
                }
            }
        }
        Color c = this.setting.get();
        c.r = (int)(r * 255.0);
        c.g = (int)(g * 255.0);
        c.b = (int)(b * 255.0);
        c.validate();
        this.rItb.set(c.r);
        this.gItb.set(c.g);
        this.bItb.set(c.b);
        this.displayQuad.color.set(c);
        this.setting.onChanged();
        this.callAction();
    }

    @Override
    public boolean toClipboard() {
        return NbtUtils.toClipboard(this.setting.get());
    }

    @Override
    public boolean fromClipboard() {
        if (!NbtUtils.fromClipboard(this.setting.get())) {
            String clipboard = MeteorClient.mc.field_1774.method_1460().trim();
            SettingColor parsed = this.parseRGBA(clipboard);
            if (parsed == null && (parsed = this.parseHex(clipboard)) == null) {
                return false;
            }
            this.setting.set(parsed);
        }
        this.setting.get().validate();
        class_437 class_4372 = this.parent;
        if (class_4372 instanceof WidgetScreen) {
            WidgetScreen p = (WidgetScreen)class_4372;
            p.reload();
        }
        this.reload();
        return true;
    }

    private SettingColor parseRGBA(String string) {
        SettingColor color;
        String[] rgba = string.replaceAll("[^0-9|,]", "").split(",");
        if (rgba.length < 3 || rgba.length > 4) {
            return null;
        }
        try {
            color = new SettingColor(Integer.parseInt(rgba[0]), Integer.parseInt(rgba[1]), Integer.parseInt(rgba[2]));
            if (rgba.length == 4) {
                color.a = Integer.parseInt(rgba[3]);
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return color;
    }

    private SettingColor parseHex(String string) {
        SettingColor color;
        if (!string.startsWith("#")) {
            return null;
        }
        String hex = string.toLowerCase().replaceAll("[^0-9a-f]", "");
        if (hex.length() != 6 && hex.length() != 8) {
            return null;
        }
        try {
            color = new SettingColor(Integer.parseInt(hex.substring(0, 2), 16), Integer.parseInt(hex.substring(2, 4), 16), Integer.parseInt(hex.substring(4, 6), 16));
            if (hex.length() == 8) {
                color.a = Integer.parseInt(hex.substring(6, 8), 16);
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return color;
    }

    private class WBrightnessQuad
    extends WWidget {
        double saturation;
        double value;
        double handleX;
        double handleY;
        boolean dragging;
        double lastMouseX;
        double lastMouseY;
        double fixedHeight = -1.0;

        private WBrightnessQuad() {
        }

        @Override
        protected void onCalculateSize() {
            double s;
            this.width = s = this.theme.scale(75.0);
            this.height = s;
            if (this.fixedHeight != -1.0) {
                this.height = this.fixedHeight;
                this.fixedHeight = -1.0;
            }
        }

        void calculateFromColor(Color c, boolean calculateNow) {
            double min = Math.min(Math.min(c.r, c.g), c.b);
            double max = Math.max(Math.max(c.r, c.g), c.b);
            double delta = max - min;
            this.value = max / 255.0;
            this.saturation = delta == 0.0 ? 0.0 : delta / max;
            if (calculateNow) {
                this.handleX = this.saturation * this.width;
                this.handleY = (1.0 - this.value) * this.height;
            }
        }

        @Override
        public boolean onMouseClicked(double mouseX, double mouseY, int button, boolean used) {
            if (used) {
                return false;
            }
            if (this.mouseOver) {
                this.dragging = true;
                this.handleX = this.lastMouseX - this.x;
                this.handleY = this.lastMouseY - this.y;
                this.handleMoved();
                return true;
            }
            return false;
        }

        @Override
        public boolean onMouseReleased(double mouseX, double mouseY, int button) {
            if (this.dragging) {
                this.dragging = false;
            }
            return false;
        }

        @Override
        public void onMouseMoved(double mouseX, double mouseY, double lastMouseX, double lastMouseY) {
            if (this.dragging) {
                if (mouseX >= this.x && mouseX <= this.x + this.width) {
                    this.handleX += mouseX - lastMouseX;
                } else if (this.handleX > 0.0 && mouseX < this.x) {
                    this.handleX = 0.0;
                } else if (this.handleX < this.width && mouseX > this.x + this.width) {
                    this.handleX = this.width;
                }
                if (mouseY >= this.y && mouseY <= this.y + this.height) {
                    this.handleY += mouseY - lastMouseY;
                } else if (this.handleY > 0.0 && mouseY < this.y) {
                    this.handleY = 0.0;
                } else if (this.handleY < this.height && mouseY > this.y + this.height) {
                    this.handleY = this.height;
                }
                this.handleMoved();
            }
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
        }

        void handleMoved() {
            double handleXPercentage = this.handleX / this.width;
            double handleYPercentage = this.handleY / this.height;
            this.saturation = handleXPercentage;
            this.value = 1.0 - handleYPercentage;
            ColorSettingScreen.this.hsvChanged();
        }

        @Override
        protected void onRender(GuiRenderer renderer, double mouseX, double mouseY, double delta) {
            if (this.height != this.width) {
                this.fixedHeight = this.width;
                this.invalidate();
                this.handleX = this.saturation * this.width;
                this.handleY = (1.0 - this.value) * this.fixedHeight;
            }
            ColorSettingScreen.this.hueQuad.calculateColor();
            renderer.quad(this.x, this.y, this.width, this.height, WHITE, ColorSettingScreen.this.hueQuad.color, BLACK, BLACK);
            double s = this.theme.scale(2.0);
            renderer.quad(this.x + this.handleX - s / 2.0, this.y + this.handleY - s / 2.0, s, s, WHITE);
        }
    }

    private class WHueQuad
    extends WWidget {
        private double hueAngle;
        private double handleX;
        private final Color color = new Color();
        private boolean dragging;
        private double lastMouseX;
        private boolean calculateHandleXOnLayout;

        private WHueQuad() {
        }

        @Override
        protected void onCalculateSize() {
            this.width = this.theme.scale(75.0);
            this.height = this.theme.scale(10.0);
        }

        void calculateFromSetting(boolean calculateNow) {
            Color c = ColorSettingScreen.this.setting.get();
            boolean calculated = false;
            double min = Math.min(c.r, c.g);
            min = min < (double)c.b ? min : (double)c.b;
            double max = Math.max(c.r, c.g);
            double delta = (max = max > (double)c.b ? max : (double)c.b) - min;
            if (delta < 1.0E-5) {
                this.hueAngle = 0.0;
                calculated = true;
            }
            if (!calculated) {
                if (max <= 0.0) {
                    this.hueAngle = 0.0;
                    calculated = true;
                }
                if (!calculated) {
                    this.hueAngle = (double)c.r >= max ? (double)(c.g - c.b) / delta : ((double)c.g >= max ? 2.0 + (double)(c.b - c.r) / delta : 4.0 + (double)(c.r - c.g) / delta);
                    this.hueAngle *= 60.0;
                    if (this.hueAngle < 0.0) {
                        this.hueAngle += 360.0;
                    }
                }
            }
            if (calculateNow) {
                double huePercentage = this.hueAngle / 360.0;
                this.handleX = huePercentage * this.width;
            } else {
                this.calculateHandleXOnLayout = true;
            }
        }

        @Override
        protected void onCalculateWidgetPositions() {
            if (this.calculateHandleXOnLayout) {
                double huePercentage = this.hueAngle / 360.0;
                this.handleX = huePercentage * this.width;
                this.calculateHandleXOnLayout = false;
            }
            super.onCalculateWidgetPositions();
        }

        void calculateColor() {
            double g;
            double r;
            double hh = this.hueAngle;
            if (hh >= 360.0) {
                hh = 0.0;
            }
            int i = (int)(hh /= 60.0);
            double ff = hh - (double)i;
            double p = 0.0;
            double q = 1.0 * (1.0 - 1.0 * ff);
            double t = 1.0 * (1.0 - 1.0 * (1.0 - ff));
            double b = switch (i) {
                case 0 -> {
                    r = 1.0;
                    g = t;
                    yield p;
                }
                case 1 -> {
                    r = q;
                    g = 1.0;
                    yield p;
                }
                case 2 -> {
                    r = p;
                    g = 1.0;
                    yield t;
                }
                case 3 -> {
                    r = p;
                    g = q;
                    yield 1.0;
                }
                case 4 -> {
                    r = t;
                    g = p;
                    yield 1.0;
                }
                default -> {
                    r = 1.0;
                    g = p;
                    yield q;
                }
            };
            this.color.r = (int)(r * 255.0);
            this.color.g = (int)(g * 255.0);
            this.color.b = (int)(b * 255.0);
            this.color.validate();
        }

        @Override
        public boolean onMouseClicked(double mouseX, double mouseY, int button, boolean used) {
            if (used) {
                return false;
            }
            if (this.mouseOver) {
                this.dragging = true;
                this.handleX = this.lastMouseX - this.x;
                this.calculateHueAngleFromHandleX();
                ColorSettingScreen.this.hsvChanged();
                return true;
            }
            return false;
        }

        @Override
        public boolean onMouseReleased(double mouseX, double mouseY, int button) {
            if (this.dragging) {
                this.dragging = false;
            }
            return this.mouseOver;
        }

        @Override
        public void onMouseMoved(double mouseX, double mouseY, double lastMouseX, double lastMouseY) {
            if (this.dragging) {
                if (mouseX >= this.x && mouseX <= this.x + this.width) {
                    this.handleX += mouseX - lastMouseX;
                    this.handleX = class_3532.method_15350((double)this.handleX, (double)0.0, (double)this.width);
                } else if (this.handleX > 0.0 && mouseX < this.x) {
                    this.handleX = 0.0;
                } else if (this.handleX < this.width && mouseX > this.x + this.width) {
                    this.handleX = this.width;
                }
                this.calculateHueAngleFromHandleX();
                ColorSettingScreen.this.hsvChanged();
            }
            this.lastMouseX = mouseX;
        }

        void calculateHueAngleFromHandleX() {
            double handleXPercentage = this.handleX / (this.width - 4.0);
            this.hueAngle = handleXPercentage * 360.0;
        }

        @Override
        protected void onRender(GuiRenderer renderer, double mouseX, double mouseY, double delta) {
            double sectionWidth = this.width / (double)(HUE_COLORS.length - 1);
            double sectionX = this.x;
            for (int i = 0; i < HUE_COLORS.length - 1; ++i) {
                renderer.quad(sectionX, this.y, sectionWidth, this.height, HUE_COLORS[i], HUE_COLORS[i + 1], HUE_COLORS[i + 1], HUE_COLORS[i]);
                sectionX += sectionWidth;
            }
            double s = this.theme.scale(2.0);
            renderer.quad(this.x + this.handleX - s / 2.0, this.y, s, this.height, WHITE);
        }
    }
}

