/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.accounts;

import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.minecraft.UserApiService;
import com.mojang.authlib.yggdrasil.ServicesKeySet;
import com.mojang.authlib.yggdrasil.ServicesKeyType;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.mixin.FileCacheAccessor;
import meteordevelopment.meteorclient.mixin.MinecraftClientAccessor;
import meteordevelopment.meteorclient.mixin.PlayerSkinProviderAccessor;
import meteordevelopment.meteorclient.systems.accounts.AccountCache;
import meteordevelopment.meteorclient.systems.accounts.AccountType;
import meteordevelopment.meteorclient.utils.misc.ISerializable;
import meteordevelopment.meteorclient.utils.misc.NbtException;
import net.minecraft.class_1071;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_320;
import net.minecraft.class_5520;
import net.minecraft.class_7500;
import net.minecraft.class_7569;
import net.minecraft.class_7574;
import net.minecraft.class_7853;

public abstract class Account<T extends Account<?>>
implements ISerializable<T> {
    protected AccountType type;
    protected String name;
    protected final AccountCache cache;

    protected Account(AccountType type, String name) {
        this.type = type;
        this.name = name;
        this.cache = new AccountCache();
    }

    public abstract boolean fetchInfo();

    public boolean login() {
        YggdrasilAuthenticationService authenticationService = new YggdrasilAuthenticationService(((MinecraftClientAccessor)MeteorClient.mc).meteor$getProxy());
        Account.applyLoginEnvironment(authenticationService, authenticationService.createMinecraftSessionService());
        return true;
    }

    public String getUsername() {
        if (this.cache.username.isEmpty()) {
            return this.name;
        }
        return this.cache.username;
    }

    public AccountType getType() {
        return this.type;
    }

    public AccountCache getCache() {
        return this.cache;
    }

    public static void setSession(class_320 session) {
        MinecraftClientAccessor mca = (MinecraftClientAccessor)MeteorClient.mc;
        mca.meteor$setSession(session);
        UserApiService apiService = mca.meteor$getAuthenticationService().createUserApiService(session.method_1674());
        mca.meteor$setUserApiService(apiService);
        mca.meteor$setSocialInteractionsManager(new class_5520(MeteorClient.mc, apiService));
        mca.meteor$setProfileKeys(class_7853.method_46532((UserApiService)apiService, (class_320)session, (Path)MeteorClient.mc.field_1697.toPath()));
        mca.meteor$setAbuseReportContext(class_7574.method_44599((class_7569)class_7569.method_44586(), (UserApiService)apiService));
        mca.meteor$setGameProfileFuture(CompletableFuture.supplyAsync(() -> MeteorClient.mc.method_1495().fetchProfile(MeteorClient.mc.method_1548().method_44717(), true), (Executor)class_156.method_27958()));
    }

    public static void applyLoginEnvironment(YggdrasilAuthenticationService authService, MinecraftSessionService sessService) {
        MinecraftClientAccessor mca = (MinecraftClientAccessor)MeteorClient.mc;
        mca.meteor$setAuthenticationService(authService);
        class_7500.method_44172((ServicesKeySet)authService.getServicesKeySet(), (ServicesKeyType)ServicesKeyType.PROFILE_KEY);
        mca.meteor$setSessionService(sessService);
        class_1071.class_8687 skinCache = ((PlayerSkinProviderAccessor)MeteorClient.mc.method_1582()).meteor$getSkinCache();
        Path skinCachePath = ((FileCacheAccessor)skinCache).meteor$getDirectory();
        mca.meteor$setSkinProvider(new class_1071(skinCachePath, sessService, (Executor)MeteorClient.mc));
    }

    @Override
    public class_2487 toTag() {
        class_2487 tag = new class_2487();
        tag.method_10582("type", this.type.name());
        tag.method_10582("name", this.name);
        tag.method_10566("cache", (class_2520)this.cache.toTag());
        return tag;
    }

    @Override
    public T fromTag(class_2487 tag) {
        if (tag.method_10558("name").isEmpty() || tag.method_10562("cache").isEmpty()) {
            throw new NbtException();
        }
        this.name = (String)tag.method_10558("name").get();
        this.cache.fromTag((class_2487)tag.method_10562("cache").get());
        return (T)this;
    }
}

