/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.modules.render;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import meteordevelopment.meteorclient.events.packets.PacketEvent;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.mixininterface.IVec3d;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Categories;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.entity.fakeplayer.FakePlayerEntity;
import meteordevelopment.meteorclient.utils.render.WireframeEntityRenderer;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2596;
import net.minecraft.class_2663;

public class PopChams
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<Boolean> onlyOne;
    private final Setting<Double> renderTime;
    private final Setting<Double> yModifier;
    private final Setting<Double> scaleModifier;
    private final Setting<Boolean> fadeOut;
    private final Setting<ShapeMode> shapeMode;
    private final Setting<SettingColor> sideColor;
    private final Setting<SettingColor> lineColor;
    private final List<GhostPlayer> ghosts;

    public PopChams() {
        super(Categories.Render, "pop-chams", "Renders a ghost where players pop totem.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.onlyOne = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("only-one")).description("Only allow one ghost per player.")).defaultValue(false)).build());
        this.renderTime = this.sgGeneral.add(((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("render-time")).description("How long the ghost is rendered in seconds.")).defaultValue(1.0).min(0.1).sliderMax(6.0).build());
        this.yModifier = this.sgGeneral.add(((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("y-modifier")).description("How much should the Y position of the ghost change per second.")).defaultValue(0.75).sliderRange(-4.0, 4.0).build());
        this.scaleModifier = this.sgGeneral.add(((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("scale-modifier")).description("How much should the scale of the ghost change per second.")).defaultValue(-0.25).sliderRange(-4.0, 4.0).build());
        this.fadeOut = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("fade-out")).description("Fades out the color.")).defaultValue(true)).build());
        this.shapeMode = this.sgGeneral.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("shape-mode")).description("How the shapes are rendered.")).defaultValue(ShapeMode.Both)).build());
        this.sideColor = this.sgGeneral.add(((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("side-color")).description("The side color.")).defaultValue(new SettingColor(255, 255, 255, 25)).build());
        this.lineColor = this.sgGeneral.add(((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("line-color")).description("The line color.")).defaultValue(new SettingColor(255, 255, 255, 127)).build());
        this.ghosts = new ArrayList<GhostPlayer>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDeactivate() {
        List<GhostPlayer> list = this.ghosts;
        synchronized (list) {
            this.ghosts.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    private void onReceivePacket(PacketEvent.Receive event) {
        class_1657 player;
        class_1297 entity;
        block10: {
            block9: {
                class_2596<?> class_25962 = event.packet;
                if (!(class_25962 instanceof class_2663)) {
                    return;
                }
                class_2663 p = (class_2663)class_25962;
                if (p.method_11470() != 35) {
                    return;
                }
                entity = p.method_11469((class_1937)this.mc.field_1687);
                if (!(entity instanceof class_1657)) break block9;
                player = (class_1657)entity;
                if (entity != this.mc.field_1724) break block10;
            }
            return;
        }
        List<GhostPlayer> list = this.ghosts;
        synchronized (list) {
            if (this.onlyOne.get().booleanValue()) {
                this.ghosts.removeIf(ghostPlayer -> ghostPlayer.uuid.equals(entity.method_5667()));
            }
            this.ghosts.add(new GhostPlayer(player));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    private void onRender3D(Render3DEvent event) {
        List<GhostPlayer> list = this.ghosts;
        synchronized (list) {
            this.ghosts.removeIf(ghostPlayer -> ghostPlayer.render(event));
        }
    }

    private class GhostPlayer
    extends FakePlayerEntity {
        private final UUID uuid;
        private double timer;
        private double scale;

        public GhostPlayer(class_1657 player) {
            super(player, "ghost", 20.0f, false);
            this.scale = 1.0;
            this.uuid = player.method_5667();
        }

        public boolean render(Render3DEvent event) {
            this.timer += event.frameTime;
            if (this.timer > PopChams.this.renderTime.get()) {
                return true;
            }
            this.field_5971 = this.method_23318();
            ((IVec3d)this.method_19538()).meteor$setY(this.method_23318() + PopChams.this.yModifier.get() * event.frameTime);
            this.scale += PopChams.this.scaleModifier.get() * event.frameTime;
            int preSideA = PopChams.this.sideColor.get().a;
            int preLineA = PopChams.this.lineColor.get().a;
            if (PopChams.this.fadeOut.get().booleanValue()) {
                PopChams.this.sideColor.get().a = (int)((double)PopChams.this.sideColor.get().a * (1.0 - this.timer / PopChams.this.renderTime.get()));
                PopChams.this.lineColor.get().a = (int)((double)PopChams.this.lineColor.get().a * (1.0 - this.timer / PopChams.this.renderTime.get()));
            }
            WireframeEntityRenderer.render(event, (class_1297)this, this.scale, PopChams.this.sideColor.get(), PopChams.this.lineColor.get(), PopChams.this.shapeMode.get());
            PopChams.this.sideColor.get().a = preSideA;
            PopChams.this.lineColor.get().a = preLineA;
            return false;
        }
    }
}

