/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.utils.render.postprocess;

import com.mojang.blaze3d.buffers.Std140Builder;
import com.mojang.blaze3d.buffers.Std140SizeCalculator;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import java.nio.ByteBuffer;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.renderer.FullScreenRenderer;
import meteordevelopment.meteorclient.renderer.MeshRenderer;
import net.minecraft.class_11280;
import net.minecraft.class_1297;
import net.minecraft.class_276;
import net.minecraft.class_4618;
import net.minecraft.class_6367;
import org.lwjgl.glfw.GLFW;

public abstract class PostProcessShader {
    public class_4618 vertexConsumerProvider;
    public class_276 framebuffer;
    protected RenderPipeline pipeline;
    private static final int UNIFORM_SIZE = new Std140SizeCalculator().putVec2().putFloat().get();
    private static final class_11280<UniformData> UNIFORM_STORAGE = new class_11280("Meteor - Post UBO", UNIFORM_SIZE, 16);

    public void init(RenderPipeline pipeline) {
        this.vertexConsumerProvider = new class_4618(MeteorClient.mc.method_22940().method_23000());
        this.framebuffer = new class_6367(MeteorClient.NAME + " PostProcessShader", MeteorClient.mc.method_22683().method_4489(), MeteorClient.mc.method_22683().method_4506(), true);
        this.pipeline = pipeline;
    }

    protected abstract boolean shouldDraw();

    public abstract boolean shouldDraw(class_1297 var1);

    protected void preDraw() {
    }

    protected void postDraw() {
    }

    protected abstract void setupPass(MeshRenderer var1);

    public boolean beginRender() {
        return this.shouldDraw();
    }

    public void endRender(Runnable draw) {
        if (!this.shouldDraw()) {
            return;
        }
        this.preDraw();
        draw.run();
        this.postDraw();
        MeshRenderer renderer = MeshRenderer.begin().attachments(MeteorClient.mc.method_1522()).pipeline(this.pipeline).mesh(FullScreenRenderer.mesh).uniform("PostData", UNIFORM_STORAGE.method_71102((class_11280.class_11281)new UniformData(MeteorClient.mc.method_22683().method_4489(), MeteorClient.mc.method_22683().method_4506(), (float)GLFW.glfwGetTime()))).sampler("u_Texture", this.framebuffer.method_71639());
        this.setupPass(renderer);
        renderer.end();
    }

    public void onResized(int width, int height) {
        if (this.framebuffer == null) {
            return;
        }
        this.framebuffer.method_1234(width, height);
    }

    public static void flipFrame() {
        UNIFORM_STORAGE.method_71100();
    }

    private record UniformData(float sizeX, float sizeY, float time) implements class_11280.class_11281
    {
        public void method_71104(ByteBuffer buffer) {
            Std140Builder.intoBuffer((ByteBuffer)buffer).putVec2(this.sizeX, this.sizeY).putFloat(this.time);
        }
    }
}

