/*
 * Decompiled with CFR 0.152.
 */
package baritone.api.utils;

import baritone.api.utils.BlockUtils;
import baritone.api.utils.accessor.IItemStack;
import baritone.api.utils.accessor.ILootTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_173;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_269;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2802;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_3218;
import net.minecraft.class_3264;
import net.minecraft.class_3268;
import net.minecraft.class_3283;
import net.minecraft.class_3286;
import net.minecraft.class_3300;
import net.minecraft.class_39;
import net.minecraft.class_3949;
import net.minecraft.class_47;
import net.minecraft.class_5268;
import net.minecraft.class_5304;
import net.minecraft.class_5321;
import net.minecraft.class_5350;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6756;
import net.minecraft.class_6861;
import net.minecraft.class_7655;
import net.minecraft.class_7659;
import net.minecraft.class_7699;
import net.minecraft.class_7712;
import net.minecraft.class_7780;
import net.minecraft.class_8565;
import net.minecraft.class_8567;
import net.minecraft.class_9383;
import net.minecraft.server.MinecraftServer;
import sun.misc.Unsafe;

public final class BlockOptionalMeta {
    private static final Pattern PATTERN = Pattern.compile("^(?<id>.+?)(?:\\[(?<properties>.+?)?\\])?$");
    private final class_2248 block;
    private final String propertiesDescription;
    private final Set<class_2680> blockstates;
    private final ImmutableSet<Integer> stateHashes;
    private final ImmutableSet<Integer> stackHashes;
    private static Map<class_2248, List<class_1792>> drops = new HashMap<class_2248, List<class_1792>>();
    private static Method getVanillaServerPack;

    public BlockOptionalMeta(@Nonnull class_2248 class_22482) {
        this.block = class_22482;
        this.propertiesDescription = "{}";
        this.blockstates = BlockOptionalMeta.getStates(class_22482, Collections.emptyMap());
        this.stateHashes = BlockOptionalMeta.getStateHashes(this.blockstates);
        this.stackHashes = BlockOptionalMeta.getStackHashes(this.blockstates);
    }

    public BlockOptionalMeta(@Nonnull String object) {
        object = PATTERN.matcher((CharSequence)object);
        if (!((Matcher)object).find()) {
            throw new IllegalArgumentException("invalid block selector");
        }
        this.block = BlockUtils.stringToBlockRequired(((Matcher)object).group("id"));
        Map map = (object = ((Matcher)object).group("properties")) == null || ((String)object).equals("") ? Collections.emptyMap() : BlockOptionalMeta.parseProperties(this.block, (String)object);
        this.propertiesDescription = object == null ? "{}" : "{" + ((String)object).replace("=", ":") + "}";
        this.blockstates = BlockOptionalMeta.getStates(this.block, map);
        this.stateHashes = BlockOptionalMeta.getStateHashes(this.blockstates);
        this.stackHashes = BlockOptionalMeta.getStackHashes(this.blockstates);
    }

    private static <C extends Comparable<C>, P extends class_2769<C>> P castToIProperty(Object object) {
        return (P)((class_2769)object);
    }

    private static Map<class_2769<?>, ?> parseProperties(class_2248 class_22482, String stringArray) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String string : stringArray.split(",")) {
            Object object = string.split("=");
            if (((String[])object).length != 2) {
                throw new IllegalArgumentException(String.format("\"%s\" is not a valid property-value pair", string));
            }
            string = object[0];
            object = object[1];
            string = class_22482.method_9595().method_11663(string);
            object = (Comparable)BlockOptionalMeta.castToIProperty(string).method_11900((String)object).orElseThrow(() -> BlockOptionalMeta.lambda$parseProperties$0((String)object, (class_2769)string, class_22482));
            builder.put((Object)string, object);
        }
        return builder.build();
    }

    private static Set<class_2680> getStates(@Nonnull class_2248 class_22482, @Nonnull Map<class_2769<?>, ?> map) {
        return class_22482.method_9595().method_11662().stream().filter(class_26802 -> map.entrySet().stream().allMatch(entry -> class_26802.method_11654((class_2769)entry.getKey()) == entry.getValue())).collect(Collectors.toSet());
    }

    private static ImmutableSet<Integer> getStateHashes(Set<class_2680> set) {
        return ImmutableSet.copyOf((Object[])((Integer[])set.stream().map(Object::hashCode).toArray(Integer[]::new)));
    }

    private static ImmutableSet<Integer> getStackHashes(Set<class_2680> set) {
        return ImmutableSet.copyOf((Object[])((Integer[])set.stream().flatMap(class_26802 -> BlockOptionalMeta.drops(class_26802.method_26204()).stream().map(class_17922 -> new class_1799((class_1935)class_17922, 1))).map(class_17992 -> ((IItemStack)class_17992).getBaritoneHash()).toArray(Integer[]::new)));
    }

    public final class_2248 getBlock() {
        return this.block;
    }

    public final boolean matches(@Nonnull class_2248 class_22482) {
        return class_22482 == this.block;
    }

    public final boolean matches(@Nonnull class_2680 class_26802) {
        return class_26802.method_26204() == this.block && this.stateHashes.contains((Object)class_26802.hashCode());
    }

    public final boolean matches(class_1799 class_17992) {
        int n = ((IItemStack)class_17992).getBaritoneHash() - class_17992.method_7919();
        return this.stackHashes.contains((Object)n);
    }

    public final String toString() {
        return String.format("BlockOptionalMeta{block=%s,properties=%s}", this.block, this.propertiesDescription);
    }

    public final class_2680 getAnyBlockState() {
        if (this.blockstates.size() > 0) {
            return this.blockstates.iterator().next();
        }
        return null;
    }

    public final Set<class_2680> getAllBlockStates() {
        return this.blockstates;
    }

    public final Set<Integer> stackHashes() {
        return this.stackHashes;
    }

    private static class_3268 getVanillaServerPack() {
        if (getVanillaServerPack == null) {
            getVanillaServerPack = Arrays.stream(class_3286.class.getDeclaredMethods()).filter(method -> method.getReturnType() == class_3268.class).findFirst().orElseThrow();
            getVanillaServerPack.setAccessible(true);
        }
        try {
            return (class_3268)getVanillaServerPack.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static synchronized List<class_1792> drops(class_2248 class_22482) {
        class_2248 class_22484 = class_22482;
        return drops.computeIfAbsent(class_22484, class_22483 -> {
            if (class_22483.method_26162().method_29177().equals((Object)class_39.field_844.method_29177())) {
                return Collections.emptyList();
            }
            ArrayList arrayList = new ArrayList();
            try {
                ServerLevelStub serverLevelStub = ServerLevelStub.fastCreate();
                class_22484 = new class_8567.class_8568((class_3218)serverLevelStub).method_51874(class_181.field_24424, (Object)class_243.field_1353).method_51874(class_181.field_1224, (Object)class_22484.method_9564()).method_51874(class_181.field_1229, (Object)new class_1799((class_1935)class_1802.field_22024, 1));
                BlockOptionalMeta.getDrops(class_22483, (class_8567.class_8568)class_22484).stream().map(class_1799::method_7909).forEach(arrayList::add);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return arrayList;
        });
    }

    private static List<class_1799> getDrops(class_2248 class_22482, class_8567.class_8568 class_85682) {
        class_5321 class_53212 = class_22482.method_26162();
        if (class_53212 == class_39.field_844) {
            return Collections.emptyList();
        }
        class_22482 = class_85682.method_51874(class_181.field_1224, (Object)class_22482.method_9564()).method_51875(class_173.field_1172);
        return ((ILootTable)((ServerLevelStub)class_22482.method_51863()).holder().method_58295(class_53212)).invokeGetRandomItems(new class_47.class_48((class_8567)class_22482).method_304(1L).method_309(null));
    }

    private static /* synthetic */ IllegalArgumentException lambda$parseProperties$0(String string, class_2769 class_27692, class_2248 class_22482) {
        return new IllegalArgumentException(String.format("\"%s\" is not a valid value for %s on %s", string, class_27692, class_22482));
    }

    public static class ServerLevelStub
    extends class_3218 {
        private static class_310 client = class_310.method_1551();
        private static Unsafe unsafe = ServerLevelStub.getUnsafe();
        private static CompletableFuture<class_5455> registryAccess = ServerLevelStub.load();

        public ServerLevelStub(MinecraftServer minecraftServer, Executor executor, class_32.class_5143 class_51432, class_5268 class_52682, class_5321<class_1937> class_53212, class_5363 class_53632, class_3949 class_39492, boolean bl, long l, List<class_5304> list, boolean bl2, @Nullable class_8565 class_85652) {
            super(minecraftServer, executor, class_51432, class_52682, class_53212, class_53632, class_39492, bl, l, list, bl2, class_85652);
        }

        public class_7699 method_45162() {
            assert (ServerLevelStub.client.field_1687 != null);
            return ServerLevelStub.client.field_1687.method_45162();
        }

        public static ServerLevelStub fastCreate() {
            try {
                return (ServerLevelStub)((Object)unsafe.allocateInstance(ServerLevelStub.class));
            }
            catch (InstantiationException instantiationException) {
                throw new RuntimeException(instantiationException);
            }
        }

        public class_5455 method_30349() {
            return registryAccess.join();
        }

        public class_9383.class_9385 holder() {
            return new class_9383.class_9385(this.method_30349().method_40316());
        }

        public static Unsafe getUnsafe() {
            try {
                Field field = Unsafe.class.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                return (Unsafe)field.get(null);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        public static CompletableFuture<class_5455> load() {
            class_3283 class_32832 = class_310.method_1551().method_1520();
            class_32832 = new class_6861(class_3264.field_14190, class_32832.method_29211());
            class_7780<class_7659> class_77802 = ServerLevelStub.loadAndReplaceLayer((class_3300)class_32832, (class_7780<class_7659>)class_7659.method_45139(), class_7659.field_39972, class_7655.field_39968);
            return class_5350.method_29466((class_3300)class_32832, class_77802, (class_7699)class_7712.field_40260.comp_1011(), (class_2170.class_5364)class_2170.class_5364.field_25421, (int)2, Runnable::run, (Executor)class_310.method_1551()).thenApply(class_53502 -> class_53502.method_58297().method_58289());
        }

        private static class_7780<class_7659> loadAndReplaceLayer(class_3300 class_33002, class_7780<class_7659> class_77802, class_7659 class_76592, List<class_7655.class_7657<?>> list) {
            class_33002 = ServerLevelStub.loadLayer(class_33002, class_77802, class_76592, list);
            return class_77802.method_45930((Object)class_76592, new class_5455.class_6890[]{class_33002});
        }

        private static class_5455.class_6890 loadLayer(class_3300 class_33002, class_7780<class_7659> class_68902, class_7659 class_76592, List<class_7655.class_7657<?>> list) {
            class_68902 = class_68902.method_45935((Object)class_76592);
            return class_7655.method_56515((class_3300)class_33002, (class_5455)class_68902, list);
        }

        public /* synthetic */ class_2802 method_8398() {
            return super.method_14178();
        }

        public /* synthetic */ class_6756 method_8405() {
            return super.method_14179();
        }

        public /* synthetic */ class_6756 method_8397() {
            return super.method_14196();
        }

        public /* synthetic */ class_2791 method_8392(int n, int n2) {
            return super.method_8497(n, n2);
        }

        public /* synthetic */ class_269 method_8428() {
            return super.method_14170();
        }
    }
}

