/*
 * Decompiled with CFR 0.152.
 */
package baritone.command.defaults;

import baritone.Baritone;
import baritone.api.cache.IWaypoint;
import baritone.api.cache.IWorldData;
import baritone.api.cache.Waypoint;
import baritone.api.command.Command;
import baritone.api.command.IBaritoneChatControl;
import baritone.api.command.argument.IArgConsumer;
import baritone.api.command.datatypes.ForWaypoints;
import baritone.api.command.datatypes.RelativeBlockPos;
import baritone.api.command.exception.CommandInvalidStateException;
import baritone.api.command.exception.CommandInvalidTypeException;
import baritone.api.command.helpers.Paginator;
import baritone.api.command.helpers.TabCompleteHelper;
import baritone.api.pathing.goals.GoalBlock;
import baritone.api.utils.BetterBlockPos;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;

public class WaypointsCommand
extends Command {
    private Map<IWorldData, List<IWaypoint>> a = new HashMap<IWorldData, List<IWaypoint>>();

    public WaypointsCommand(Baritone baritone) {
        super(baritone, "waypoints", "waypoint", "wp");
    }

    @Override
    public void execute(String string, IArgConsumer iArgConsumer) {
        Action action2 = iArgConsumer.hasAny() ? Action.a(iArgConsumer.getString()) : Action.a;
        if (action2 == null) {
            throw new CommandInvalidTypeException(iArgConsumer.consumed(), "an action");
        }
        Object object2 = (iWaypoint, action) -> {
            class_5250 class_52502 = class_2561.method_43470((String)"");
            class_5250 class_52503 = class_2561.method_43470((String)(iWaypoint.getTag().name() + " "));
            class_52503.method_10862(class_52503.method_10866().method_10977(class_124.field_1080));
            String string2 = iWaypoint.getName();
            class_5250 class_52504 = class_2561.method_43470((String)(!string2.isEmpty() ? string2 : "<empty>"));
            class_52504.method_10862(class_52504.method_10866().method_10977(!string2.isEmpty() ? class_124.field_1080 : class_124.field_1063));
            string2 = class_2561.method_43470((String)(" @ " + String.valueOf(new Date(iWaypoint.getCreationTimestamp()))));
            string2.method_10862(string2.method_10866().method_10977(class_124.field_1063));
            class_52502.method_10852((class_2561)class_52503);
            class_52502.method_10852((class_2561)class_52504);
            class_52502.method_10852((class_2561)string2);
            class_5250 class_52505 = class_52502;
            class_52505.method_10862(class_52505.method_10866().method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to select"))).method_10958(new class_2558(class_2558.class_2559.field_11750, String.format("%s%s %s %s @ %d", IBaritoneChatControl.FORCE_COMMAND_PREFIX, string, action.a[0], iWaypoint.getTag().getName(), iWaypoint.getCreationTimestamp()))));
            return class_52502;
        };
        Function<IWaypoint, class_2561> function = iWaypoint -> (class_2561)object2.apply(iWaypoint, action2 == Action.a ? Action.d : action2);
        if (action2 == Action.a) {
            IWaypoint[] iWaypointArray;
            IWaypoint.Tag tag = iArgConsumer.hasAny() ? IWaypoint.Tag.getByName(iArgConsumer.peekString()) : null;
            if (tag != null) {
                iArgConsumer.get();
            }
            if ((iWaypointArray = tag != null ? ForWaypoints.getWaypointsByTag(this.baritone, tag) : ForWaypoints.getWaypoints(this.baritone)).length > 0) {
                iArgConsumer.requireMax(1);
                Paginator.paginate(iArgConsumer, iWaypointArray, () -> this.logDirect(tag != null ? String.format("All waypoints by tag %s:", tag.name()) : "All waypoints:"), function, String.format("%s%s %s%s", IBaritoneChatControl.FORCE_COMMAND_PREFIX, string, action2.a[0], tag != null ? " " + tag.getName() : ""));
                return;
            }
            iArgConsumer.requireMax(0);
            throw new CommandInvalidStateException(tag != null ? "No waypoints found by that tag" : "No waypoints found");
        }
        if (action2 == Action.c) {
            IWaypoint.Tag tag = iArgConsumer.hasAny() ? IWaypoint.Tag.getByName(iArgConsumer.peekString()) : null;
            if (tag == null) {
                tag = IWaypoint.Tag.USER;
            } else {
                iArgConsumer.get();
            }
            String string2 = iArgConsumer.hasExactlyOne() || iArgConsumer.hasExactly(4) ? iArgConsumer.getString() : "";
            BetterBlockPos betterBlockPos = iArgConsumer.hasAny() ? (BetterBlockPos)((Object)iArgConsumer.getDatatypePost(RelativeBlockPos.INSTANCE, this.ctx.playerFeet())) : this.ctx.playerFeet();
            iArgConsumer.requireMax(0);
            Waypoint waypoint = new Waypoint(string2, tag, betterBlockPos);
            ForWaypoints.waypoints(this.baritone).addWaypoint(waypoint);
            class_5250 class_52502 = class_2561.method_43470((String)"Waypoint added: ");
            class_52502.method_10862(class_52502.method_10866().method_10977(class_124.field_1080));
            class_52502.method_10852((class_2561)object2.apply(waypoint, Action.d));
            this.logDirect(new class_2561[]{class_52502});
            return;
        }
        if (action2 == Action.b) {
            class_5250 class_52503;
            iArgConsumer.requireMax(1);
            String string3 = iArgConsumer.getString();
            IWaypoint.Tag tag = IWaypoint.Tag.getByName(string3);
            if (tag == null) {
                throw new CommandInvalidStateException("Invalid tag, \"" + string3 + "\"");
            }
            class_5250 class_52504 = class_52503 = ForWaypoints.getWaypointsByTag(this.baritone, tag);
            int n = ((IWaypoint[])class_52503).length;
            for (int i = 0; i < n; ++i) {
                IWaypoint iWaypoint2 = class_52504[i];
                ForWaypoints.waypoints(this.baritone).removeWaypoint(iWaypoint2);
            }
            this.a.computeIfAbsent(this.baritone.getWorldProvider().getCurrentWorld(), iWorldData -> new ArrayList()).addAll(Arrays.asList(class_52503));
            class_52504 = class_2561.method_43470((String)String.format("Cleared %d waypoints, click to restore them", ((IWaypoint[])class_52503).length));
            class_52504.method_10862(class_52504.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11750, String.format("%s%s restore @ %s", IBaritoneChatControl.FORCE_COMMAND_PREFIX, string, Stream.of(class_52503).map(iWaypoint -> Long.toString(iWaypoint.getCreationTimestamp())).collect(Collectors.joining(" "))))));
            this.logDirect(new class_2561[]{class_52504});
            return;
        }
        if (action2 == Action.f) {
            ArrayList<Object> arrayList = new ArrayList();
            List list = this.a.getOrDefault(this.baritone.getWorldProvider().getCurrentWorld(), Collections.emptyList());
            if (iArgConsumer.peekString().equals("@")) {
                iArgConsumer.get();
                block5: while (iArgConsumer.hasAny()) {
                    long l = iArgConsumer.getAs(Long.class);
                    for (Object object2 : list) {
                        if (object2.getCreationTimestamp() != l) continue;
                        arrayList.add(object2);
                        continue block5;
                    }
                }
            } else {
                iArgConsumer.requireExactly(1);
                int n = list.size();
                int n2 = Math.min(n, iArgConsumer.getAs(Integer.class));
                arrayList = new ArrayList(list.subList(n - n2, n));
            }
            arrayList.forEach(ForWaypoints.waypoints(this.baritone)::addWaypoint);
            list.removeIf(arrayList::contains);
            this.logDirect(String.format("Restored %d waypoints", arrayList.size()));
            return;
        }
        class_5250 class_52505 = (class_5250)iArgConsumer.getDatatypeFor(ForWaypoints.INSTANCE);
        IWaypoint iWaypoint3 = null;
        if (iArgConsumer.hasAny() && iArgConsumer.peekString().equals("@")) {
            iArgConsumer.requireExactly(2);
            iArgConsumer.get();
            long l = iArgConsumer.getAs(Long.class);
            for (IWaypoint iWaypoint4 : class_52505) {
                if (iWaypoint4.getCreationTimestamp() != l) continue;
                iWaypoint3 = iWaypoint4;
                break;
            }
            if (iWaypoint3 == null) {
                throw new CommandInvalidStateException("Timestamp was specified but no waypoint was found");
            }
        } else {
            switch (((IWaypoint[])class_52505).length) {
                case 0: {
                    throw new CommandInvalidStateException("No waypoints found");
                }
                case 1: {
                    iWaypoint3 = class_52505[0];
                }
            }
        }
        if (iWaypoint3 == null) {
            iArgConsumer.requireMax(1);
            Paginator.paginate(iArgConsumer, class_52505, () -> this.logDirect("Multiple waypoints were found:"), function, String.format("%s%s %s %s", IBaritoneChatControl.FORCE_COMMAND_PREFIX, string, action2.a[0], iArgConsumer.consumedString()));
            return;
        }
        if (action2 == Action.d) {
            this.logDirect(function.apply(iWaypoint3));
            this.logDirect(String.format("Position: %s", new Object[]{iWaypoint3.getLocation()}));
            class_5250 class_52506 = class_2561.method_43470((String)"Click to delete this waypoint");
            class_52506.method_10862(class_52506.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11750, String.format("%s%s delete %s @ %d", IBaritoneChatControl.FORCE_COMMAND_PREFIX, string, iWaypoint3.getTag().getName(), iWaypoint3.getCreationTimestamp()))));
            class_5250 class_52507 = class_2561.method_43470((String)"Click to set goal to this waypoint");
            class_52507.method_10862(class_52507.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11750, String.format("%s%s goal %s @ %d", IBaritoneChatControl.FORCE_COMMAND_PREFIX, string, iWaypoint3.getTag().getName(), iWaypoint3.getCreationTimestamp()))));
            class_5250 class_52508 = class_2561.method_43470((String)"Click to show a command to recreate this waypoint");
            class_52508.method_10862(class_52508.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11745, String.format("%s%s save %s %s %s %s %s", Baritone.a().prefix.value, string, iWaypoint3.getTag().getName(), iWaypoint3.getName(), iWaypoint3.getLocation().x, iWaypoint3.getLocation().y, iWaypoint3.getLocation().z))));
            class_5250 class_52509 = class_2561.method_43470((String)"Click to return to the waypoints list");
            class_52509.method_10862(class_52509.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11750, String.format("%s%s list", IBaritoneChatControl.FORCE_COMMAND_PREFIX, string))));
            this.logDirect(new class_2561[]{class_52506});
            this.logDirect(new class_2561[]{class_52507});
            this.logDirect(new class_2561[]{class_52508});
            this.logDirect(new class_2561[]{class_52509});
            return;
        }
        if (action2 == Action.e) {
            ForWaypoints.waypoints(this.baritone).removeWaypoint(iWaypoint3);
            this.a.computeIfAbsent(this.baritone.getWorldProvider().getCurrentWorld(), iWorldData -> new ArrayList()).add(iWaypoint3);
            class_5250 class_525010 = class_2561.method_43470((String)"That waypoint has successfully been deleted, click to restore it");
            class_525010.method_10862(class_525010.method_10866().method_10958(new class_2558(class_2558.class_2559.field_11750, String.format("%s%s restore @ %s", IBaritoneChatControl.FORCE_COMMAND_PREFIX, string, iWaypoint3.getCreationTimestamp()))));
            this.logDirect(new class_2561[]{class_525010});
            return;
        }
        if (action2 == Action.g) {
            GoalBlock goalBlock = new GoalBlock(iWaypoint3.getLocation());
            this.baritone.getCustomGoalProcess().setGoal(goalBlock);
            this.logDirect(String.format("Goal: %s", goalBlock));
            return;
        }
        if (action2 == Action.h) {
            GoalBlock goalBlock = new GoalBlock(iWaypoint3.getLocation());
            this.baritone.getCustomGoalProcess().setGoalAndPath(goalBlock);
            this.logDirect(String.format("Going to: %s", goalBlock));
        }
    }

    @Override
    public Stream<String> tabComplete(String object, IArgConsumer iArgConsumer) {
        if (iArgConsumer.hasAny()) {
            if (iArgConsumer.hasExactlyOne()) {
                return new TabCompleteHelper().append(Action.a()).sortAlphabetically().filterPrefix(iArgConsumer.getString()).stream();
            }
            object = Action.a(iArgConsumer.getString());
            if (iArgConsumer.hasExactlyOne()) {
                if (object == Action.a || object == Action.c || object == Action.b) {
                    return new TabCompleteHelper().append(IWaypoint.Tag.getAllNames()).sortAlphabetically().filterPrefix(iArgConsumer.getString()).stream();
                }
                if (object == Action.f) {
                    return Stream.empty();
                }
                return iArgConsumer.tabCompleteDatatype(ForWaypoints.INSTANCE);
            }
            if (iArgConsumer.has(3) && object == Action.c) {
                iArgConsumer.get();
                iArgConsumer.get();
                return iArgConsumer.tabCompleteDatatype(RelativeBlockPos.INSTANCE);
            }
        }
        return Stream.empty();
    }

    @Override
    public String getShortDesc() {
        return "Manage waypoints";
    }

    @Override
    public List<String> getLongDesc() {
        return Arrays.asList("The waypoint command allows you to manage Baritone's waypoints.", "", "Waypoints can be used to mark positions for later. Waypoints are each given a tag and an optional name.", "", "Note that the info, delete, and goal commands let you specify a waypoint by tag. If there is more than one waypoint with a certain tag, then they will let you select which waypoint you mean.", "", "Missing arguments for the save command use the USER tag, creating an unnamed waypoint and your current position as defaults.", "", "Usage:", "> wp [l/list] - List all waypoints.", "> wp <l/list> <tag> - List all waypoints by tag.", "> wp <s/save> - Save an unnamed USER waypoint at your current position", "> wp <s/save> [tag] [name] [pos] - Save a waypoint with the specified tag, name and position.", "> wp <i/info/show> <tag/name> - Show info on a waypoint by tag or name.", "> wp <d/delete> <tag/name> - Delete a waypoint by tag or name.", "> wp <restore> <n> - Restore the last n deleted waypoints.", "> wp <c/clear> <tag> - Delete all waypoints with the specified tag.", "> wp <g/goal> <tag/name> - Set a goal to a waypoint by tag or name.", "> wp <goto> <tag/name> - Set a goal to a waypoint by tag or name and start pathing.");
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    static final class Action
    extends Enum<Action> {
        public static final /* enum */ Action a = new Action("list", "get", "l");
        public static final /* enum */ Action b = new Action("clear", "c");
        public static final /* enum */ Action c = new Action("save", "s");
        public static final /* enum */ Action d = new Action("info", "show", "i");
        public static final /* enum */ Action e = new Action("delete", "d");
        public static final /* enum */ Action f = new Action("restore");
        public static final /* enum */ Action g = new Action("goal", "g");
        public static final /* enum */ Action h = new Action("goto");
        final String[] a;
        private static final /* synthetic */ Action[] a;

        public static Action[] values() {
            return (Action[])a.clone();
        }

        public static Action valueOf(String string) {
            return Enum.valueOf(Action.class, string);
        }

        private Action(String ... stringArray) {
            this.a = stringArray;
        }

        public static Action a(String string) {
            for (Action action : Action.values()) {
                String[] stringArray = action.a;
                int n = action.a.length;
                for (int i = 0; i < n; ++i) {
                    if (!stringArray[i].equalsIgnoreCase(string)) continue;
                    return action;
                }
            }
            return null;
        }

        public static String[] a() {
            HashSet<String> hashSet = new HashSet<String>();
            for (Action action : Action.values()) {
                hashSet.addAll(Arrays.asList(action.a));
            }
            return hashSet.toArray(new String[0]);
        }

        static {
            a = new Action[]{a, b, c, d, e, f, g, h};
        }
    }
}

