/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient;

import java.io.File;
import java.lang.invoke.MethodHandles;
import meteordevelopment.meteorclient.addons.AddonManager;
import meteordevelopment.meteorclient.addons.MeteorAddon;
import meteordevelopment.meteorclient.events.game.OpenScreenEvent;
import meteordevelopment.meteorclient.events.meteor.KeyEvent;
import meteordevelopment.meteorclient.events.meteor.MouseButtonEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.gui.GuiThemes;
import meteordevelopment.meteorclient.gui.WidgetScreen;
import meteordevelopment.meteorclient.gui.tabs.Tabs;
import meteordevelopment.meteorclient.systems.Systems;
import meteordevelopment.meteorclient.systems.config.Config;
import meteordevelopment.meteorclient.systems.modules.Categories;
import meteordevelopment.meteorclient.systems.modules.Modules;
import meteordevelopment.meteorclient.systems.modules.misc.DiscordPresence;
import meteordevelopment.meteorclient.utils.PostInit;
import meteordevelopment.meteorclient.utils.PreInit;
import meteordevelopment.meteorclient.utils.ReflectInit;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.misc.Version;
import meteordevelopment.meteorclient.utils.misc.input.KeyAction;
import meteordevelopment.meteorclient.utils.misc.input.KeyBinds;
import meteordevelopment.meteorclient.utils.network.OnlinePlayers;
import meteordevelopment.orbit.EventBus;
import meteordevelopment.orbit.EventHandler;
import meteordevelopment.orbit.IEventBus;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_408;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeteorClient
implements ClientModInitializer {
    public static final String MOD_ID = "meteor-client";
    public static final ModMetadata MOD_META;
    public static final String NAME;
    public static final Version VERSION;
    public static final String DEV_BUILD;
    public static MeteorClient INSTANCE;
    public static MeteorAddon ADDON;
    public static class_310 mc;
    public static final IEventBus EVENT_BUS;
    public static final File FOLDER;
    public static final Logger LOG;
    private boolean wasWidgetScreen;
    private boolean wasHudHiddenRoot;

    public void onInitializeClient() {
        if (INSTANCE == null) {
            INSTANCE = this;
            return;
        }
        LOG.info("Initializing {}", (Object)NAME);
        mc = class_310.method_1551();
        if (!FOLDER.exists()) {
            FOLDER.getParentFile().mkdirs();
            FOLDER.mkdir();
            Systems.addPreLoadTask(() -> Modules.get().get(DiscordPresence.class).toggle());
        }
        AddonManager.init();
        AddonManager.ADDONS.forEach(addon -> {
            try {
                EVENT_BUS.registerLambdaFactory(addon.getPackage(), (lookupInMethod, klass) -> (MethodHandles.Lookup)lookupInMethod.invoke(null, klass, MethodHandles.lookup()));
            }
            catch (AbstractMethodError e) {
                throw new RuntimeException("Addon \"%s\" is too old and cannot be ran.".formatted(addon.name), e);
            }
        });
        ReflectInit.registerPackages();
        ReflectInit.init(PreInit.class);
        Categories.init();
        Systems.init();
        EVENT_BUS.subscribe(this);
        AddonManager.ADDONS.forEach(MeteorAddon::onInitialize);
        Modules.get().sortModules();
        Systems.load();
        ReflectInit.init(PostInit.class);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            OnlinePlayers.leave();
            Systems.save();
            GuiThemes.save();
        }));
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        if (MeteorClient.mc.field_1755 == null && mc.method_18506() == null && KeyBinds.OPEN_COMMANDS.method_1436()) {
            mc.method_1507((class_437)new class_408(Config.get().prefix.get()));
        }
    }

    @EventHandler
    private void onKey(KeyEvent event) {
        if (event.action == KeyAction.Press && KeyBinds.OPEN_GUI.method_1417(event.key, 0)) {
            this.toggleGui();
        }
    }

    @EventHandler
    private void onMouseButton(MouseButtonEvent event) {
        if (event.action == KeyAction.Press && KeyBinds.OPEN_GUI.method_1433(event.button)) {
            this.toggleGui();
        }
    }

    private void toggleGui() {
        if (Utils.canCloseGui()) {
            MeteorClient.mc.field_1755.method_25419();
        } else if (Utils.canOpenGui()) {
            Tabs.get().getFirst().openScreen(GuiThemes.get());
        }
    }

    @EventHandler(priority=-200)
    private void onOpenScreen(OpenScreenEvent event) {
        boolean hideHud = GuiThemes.get().hideHUD();
        if (hideHud) {
            if (!this.wasWidgetScreen) {
                this.wasHudHiddenRoot = MeteorClient.mc.field_1690.field_1842;
            }
            if (event.screen instanceof WidgetScreen) {
                MeteorClient.mc.field_1690.field_1842 = true;
            } else if (!this.wasHudHiddenRoot) {
                MeteorClient.mc.field_1690.field_1842 = false;
            }
        }
        this.wasWidgetScreen = event.screen instanceof WidgetScreen;
    }

    public static class_2960 identifier(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    static {
        EVENT_BUS = new EventBus();
        FOLDER = FabricLoader.getInstance().getGameDir().resolve(MOD_ID).toFile();
        MOD_META = ((ModContainer)FabricLoader.getInstance().getModContainer(MOD_ID).orElseThrow()).getMetadata();
        NAME = MOD_META.getName();
        LOG = LoggerFactory.getLogger((String)NAME);
        String versionString = MOD_META.getVersion().getFriendlyString();
        if (versionString.contains("-")) {
            versionString = versionString.split("-")[0];
        }
        if (versionString.equals("${version}")) {
            versionString = "0.0.0";
        }
        VERSION = new Version(versionString);
        DEV_BUILD = MOD_META.getCustomValue("meteor-client:devbuild").getAsString();
    }
}

