/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.commands.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import meteordevelopment.meteorclient.commands.Command;
import meteordevelopment.meteorclient.utils.player.InvUtils;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2172;
import net.minecraft.class_2287;
import net.minecraft.class_2561;
import net.minecraft.class_7157;
import net.minecraft.class_746;

public class DropCommand
extends Command {
    private static final SimpleCommandExceptionType NOT_SPECTATOR = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Can't drop items while in spectator."));
    private static final SimpleCommandExceptionType NO_SUCH_ITEM = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Could not find an item with that name!"));

    public DropCommand() {
        super("drop", "Automatically drops specified items.", new String[0]);
    }

    @Override
    public void build(LiteralArgumentBuilder<class_2172> builder) {
        builder.then(DropCommand.literal("hand").executes(context -> this.drop(player -> player.method_7290(true))));
        builder.then(DropCommand.literal("offhand").executes(context -> this.drop(player -> InvUtils.drop().slotOffhand())));
        builder.then(DropCommand.literal("hotbar").executes(context -> this.drop(player -> {
            for (int i = 0; i < 9; ++i) {
                InvUtils.drop().slotHotbar(i);
            }
        })));
        builder.then(DropCommand.literal("inventory").executes(context -> this.drop(player -> {
            for (int i = 9; i < player.method_31548().field_7547.size(); ++i) {
                InvUtils.drop().slotMain(i - 9);
            }
        })));
        builder.then(DropCommand.literal("all").executes(context -> this.drop(player -> {
            for (int i = 0; i < player.method_31548().method_5439(); ++i) {
                InvUtils.drop().slot(i);
            }
            InvUtils.drop().slotOffhand();
        })));
        builder.then(DropCommand.literal("armor").executes(context -> this.drop(player -> {
            for (int i = 0; i < player.method_31548().field_7548.size(); ++i) {
                InvUtils.drop().slotArmor(i);
            }
        })));
        builder.then(DropCommand.argument("item", class_2287.method_9776((class_7157)REGISTRY_ACCESS)).executes(context -> this.drop(player -> {
            class_1799 stack = class_2287.method_9777((CommandContext)context, (String)"item").method_9781(1, false);
            if (stack == null || stack.method_7909() == class_1802.field_8162) {
                throw NO_SUCH_ITEM.create();
            }
            for (int i = 0; i < player.method_31548().method_5439(); ++i) {
                if (stack.method_7909() != player.method_31548().method_5438(i).method_7909()) continue;
                InvUtils.drop().slot(i);
            }
        })));
    }

    private int drop(PlayerConsumer consumer) throws CommandSyntaxException {
        if (DropCommand.mc.field_1724.method_7325()) {
            throw NOT_SPECTATOR.create();
        }
        consumer.accept(DropCommand.mc.field_1724);
        return 1;
    }

    @FunctionalInterface
    private static interface PlayerConsumer {
        public void accept(class_746 var1) throws CommandSyntaxException;
    }
}

